<?php
// #############################################################################
/**
* Prints a label row with the recommendation details
*
* @param	string	Name for recommendation row
*/
function print_recommendation_row($name)
{
	global $vbulletin, $vbphrase, $stylevar;

	print_label_row($vbphrase['dbtech_vbsecurity_recommendation_' . $name], 
		(!VBSECURITY::$cache['recommendations'][$name] ? 
			'<img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsecurity/images/good.png" style="float: ' . $stylevar['right'] . '; padding-right: 10px; vertical-align: middle;" alt="" />
				' . $vbphrase['dbtech_vbsecurity_recommendation_' . $name . '_good'] :
			'<img src="' . $vbulletin->options['bburl'] . '/dbtech/vbsecurity/images/bad.png" style="float: ' . $stylevar['right'] . '; padding-right: 10px; vertical-align: middle;" alt="" />
				' . construct_phrase($vbphrase['dbtech_vbsecurity_recommendation_' . $name . '_bad'], VBSECURITY::$cache['recommendations'][$name])
		)
	);
}

// #############################################################################
/**
* Constructs a row containing a list of <input type="checkbox" />
*
* @param	string	Name for checkbox
* @param	array	Values to use
* @param	boolean	Whether or not to check the box
* @param	boolean	Whether or not to htmlspecialchars the title
*/
function construct_checkbox_array_row($name, $array, $selected = '', $htmlise = false)
{
	global $vbulletin;

	if (function_exists('fetch_uniqueid_counter'))
	{
		$uniqueid = fetch_uniqueid_counter();
	}

	if (!is_array($array))
	{
		$array = array();
		$selected = array();
	}

	$check = "<div id=\"ctrl_$name\">\n";
	$check .= construct_checkbox_options($name, $array, $selected, $htmlise);
	$check .= "</div>\n";

	return $check;
}

// #############################################################################
/**
* Creates <input type="checkbox" /> from an array
*
* @param	string	Name for checkbox
* @param	array	Values to use
* @param	boolean	Whether or not to check the box
* @param	string	Value for checkbox
* @param	string	Text label for checkbox
* @param	string	Optional Javascript code to run when checkbox is clicked - example: ' onclick="do_something()"'
*/
function construct_checkbox_options($name, $array, $selected = '', $htmlise = false)
{
	global $vbulletin;

	$box = '';
	
	foreach ($array as $value => $title)
	{
		if (function_exists('fetch_uniqueid_counter'))
		{
			$uniqueid = fetch_uniqueid_counter();
		}
		$checked = (bool)($selected & $value);
		$box .= "<div id=\"ctrl_$name_$value\"><label for=\"{$name}_$uniqueid\" class=\"smallfont\"><input type=\"hidden\" name=\"{$name}\" value=\"0\" tabindex=\"1\" /><input type=\"checkbox\" name=\"{$name}\" id=\"{$name}_$uniqueid\" value=\"$value\" tabindex=\"1\"" . iif($onclick, " onclick=\"$onclick\"") . iif($vbulletin->debug, " title=\"name=&quot;{$name}&quot;\"") . iif($checked, ' checked="checked"') . " />" . iif($htmlise, htmlspecialchars_uni($title), $title) . "</label></div>\n";
	}

	return $box;
}

if (intval($vbulletin->versionnumber) == 3)
{
// #############################################################################
/**
* Prints a dialog box asking if the user if they want to continue
*
* @param	string	Phrase that is presented to the user
* @param	string	PHP script to which the form will submit
* @param	string	'do' action for target script
* @param	mixed		If not empty, an array containing name=>value pairs to be used as hidden input fields
*/
function print_confirmation($phrase, $phpscript, $do, $hiddenfields = array())
{
	global $vbulletin, $vbphrase;

	echo "<p>&nbsp;</p><p>&nbsp;</p>";
	print_form_header($phpscript, $do, 0, 1, '', '75%');
	if (is_array($hiddenfields))
	{
		foreach($hiddenfields AS $varname => $value)
		{
			construct_hidden_code($varname, $value);
		}
	}
	print_table_header($vbphrase['confirm_action']);
	print_description_row("
		<blockquote><br />
		$phrase
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
}
}

if (!function_exists('generatePassword'))
{
	function generatePassword($length)
	{
		try
		{
			if (!function_exists('openssl_random_pseudo_bytes'))
			{
				throw new Exception();
			}

			$bytes = openssl_random_pseudo_bytes($length + 1, $strong);
			if ($bytes === false OR $strong !== true)
			{
				throw new Exception();
			}
		}
		catch (Exception $e)
		{
			$bytes = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-=~!@#$%^&*()_+,./<>?;:[]{}\|'), 0, $length);
		}

		return substr(preg_replace('/[^a-zA-Z0-9]/', '', base64_encode($bytes)), 0, $length);
	}
}
?>